/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import jclass.cell.BaseInitialEvent;
import jclass.cell.CellRenderer;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.table3.Clip;
import jclass.table3.JCAdjustable;
import jclass.table3.JCCellPosition;
import jclass.table3.JCCellRange;
import jclass.table3.JCResizeCellEvent;
import jclass.table3.JCSelectEvent;
import jclass.table3.JCStringCellData;
import jclass.table3.JCStringCellRenderer;
import jclass.table3.JCTraverseCellEvent;
import jclass.table3.LabelTrigger;
import jclass.table3.Select;
import jclass.table3.Sort;
import jclass.table3.StringCellRangeFlavor;
import jclass.table3.Table;
import jclass.table3.TableScrollbar;
import jclass.table3.VectorDataSource;
import jclass.table3.Widget;
import jclass.util.JCEnvironment;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

class InputHandler
implements Runnable,
Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    static int NULL_CURSOR = -1;
    static int DEFAULT_CURSOR;
    static int TRAV_CURSOR;
    static int NONTRAV_CURSOR;
    static int CORNER_CURSOR;
    static int HORIZ_CURSOR;
    static int VERT_CURSOR;
    static int MOVE_CURSOR;
    static int WAIT_CURSOR;
    private final int KEY_DOWN = 40;
    private final int KEY_UP = 38;
    private final int KEY_LEFT = 37;
    private final int KEY_RIGHT = 39;
    private final int KEY_PAGE_UP = 33;
    private final int KEY_PAGE_DOWN = 34;
    private final int KEY_TAB = 9;
    private final int KEY_ESCAPE = 27;
    private final int KEY_HOME = 36;
    private final int KEY_END = 35;
    private final int KEY_ENTER = 10;
    Table table;
    int resize_row;
    int resize_column;
    JCCellRange span = new JCCellRange();
    int x_save = -999;
    int y_save;
    int save_row;
    int save_column;
    JCCellPosition initialCell;
    Point initialPoint;
    Point lastPoint;
    Point upPoint;
    Point currentPoint;
    boolean selecting = false;
    boolean extended = false;
    boolean sorting = false;
    boolean menu = false;
    boolean dragging = false;
    InitialEvent initialEvent;
    long when;
    int modifiers;
    int clickCount;
    private static final int AUTO_SCROLL_DEC = -1;
    private static final int AUTO_SCROLL_NOVALUE = 0;
    private static final int AUTO_SCROLL_INC = 1;
    private static final int AUTO_SCROLL_AMOUNT = 20;
    boolean autoscrolling = false;
    boolean auto_scroll_horiz = false;
    boolean auto_scroll_vert = false;
    int auto_scroll_horiz_direction = 0;
    int auto_scroll_vert_direction = 0;
    Thread auto_scroll_thread;
    JCCellPosition auto_scroll_initialCell;
    Point auto_scroll_initialPoint;
    private static final int DELTA = 4;
    private static final int MINSIZE = 5;
    private static final int SELECT = 1;
    private static final int DESELECT = 2;
    private static final int DISALLOWED = -1000;
    private static final int TOGGLE = -1001;
    boolean DEBUG_MODE = false;
    private final int MOUSE_DRAG = 0;
    private final int MOUSE_MOVED = 1;
    private final int MOUSE_PRESSED = 2;
    private final int MOUSE_RELEASED = 3;
    private final int MOUSE_ENTERED = 4;
    private final int MOUSE_EXITED = 5;
    private final int KEY_PRESSED = 6;
    private final int KEY_RELEASED = 7;
    private final int SELECTING = 8;
    private final int COPYING = 9;
    Clipboard clipboard;
    static JCCellPosition xyToCellPosition;
    Clip clip;
    JCCellPosition oldPos;
    String prevParam;

    public InputHandler(Table table) {
        this.table = table;
    }

    public static boolean isShift(int n) {
        return (n & 1) != 0;
    }

    public static boolean isControl(int n) {
        return (n & 2) != 0;
    }

    public static boolean isAlt(int n) {
        return (n & 8) != 0;
    }

    public static boolean isMeta(int n) {
        return (n & 4) != 0;
    }

    Clip getClip(int n, int n2) {
        Component component = this.table.locate(n, n2);
        if (component instanceof Clip) {
            return (Clip)component;
        }
        return null;
    }

    public JCCellPosition XYToCellPosition(int n, int n2) {
        JCCellPosition jCCellPosition = this.XYToCell(n, n2);
        if (jCCellPosition == null) {
            return null;
        }
        return new JCCellPosition(jCCellPosition.row, jCCellPosition.column);
    }

    public JCCellPosition XYToCell(int n, int n2) {
        Clip clip = this.getClip(n, n2);
        if (clip == null) {
            return null;
        }
        n -= clip.location().x;
        n2 -= clip.location().y;
        int n3 = -999;
        int n4 = -999;
        switch (clip.type) {
            case 4: 
            case 6: {
                n4 = this.table.YtoRow(n2 + clip.yOffset() + clip.vert_origin);
                n3 = -1;
                if (n4 < this.table.rows && n4 >= 0) break;
                return null;
            }
            case 5: 
            case 7: {
                n4 = -1;
                n3 = this.table.XtoColumn(n + clip.xOffset() + clip.horiz_origin);
                if (n3 < this.table.columns && n3 >= 0) break;
                return null;
            }
            default: {
                n4 = this.table.YtoRow(n2 + clip.yOffset() + clip.vert_origin);
                n3 = this.table.XtoColumn(n + clip.xOffset() + clip.horiz_origin);
                if (n4 >= this.table.rows || n4 < 0) {
                    return null;
                }
                if (n3 < this.table.columns && n3 >= 0) break;
                return null;
            }
        }
        xyToCellPosition.reshape(n4, n3);
        return xyToCellPosition;
    }

    public JCCellPosition XYToCellPosition(boolean bl, boolean bl2, Point point) {
        JCCellPosition jCCellPosition = this.XYToCell(bl, bl2, point);
        if (jCCellPosition == null) {
            return null;
        }
        return new JCCellPosition(jCCellPosition.row, jCCellPosition.column);
    }

    public JCCellPosition XYToCell(boolean bl, boolean bl2, Point point) {
        if (point == null) {
            return null;
        }
        int n = point.x;
        int n2 = point.y;
        Clip clip = this.getClip(n, n2);
        if (clip == null) {
            return null;
        }
        JCCellPosition jCCellPosition = this.XYToCell(n, n2);
        if (jCCellPosition == null) {
            return null;
        }
        int n3 = jCCellPosition.row;
        int n4 = jCCellPosition.column;
        n -= clip.location().x;
        n2 -= clip.location().y;
        if (clip.type != 0 && bl2) {
            if (clip.isVertical() && !this.table.isRowVisible(n3)) {
                return null;
            }
            if (clip.isHorizontal() && !this.table.isColumnVisible(n4)) {
                return null;
            }
        }
        if (bl) {
            n -= this.table.columnPosition(n4) - clip.horiz_origin;
            n2 -= this.table.rowPosition(n3) - clip.vert_origin;
        } else {
            n += clip.horiz_origin;
            n2 += clip.vert_origin;
        }
        point.x = n;
        point.y = n2;
        return jCCellPosition;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.when = mouseEvent.getWhen();
        this.modifiers = mouseEvent.getModifiers();
        this.clickCount = mouseEvent.getClickCount();
        this.mouseDragged(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.when = mouseEvent.getWhen();
        this.modifiers = mouseEvent.getModifiers();
        this.clickCount = mouseEvent.getClickCount();
        this.mouseMoved(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.when = mouseEvent.getWhen();
        this.modifiers = mouseEvent.getModifiers();
        this.clickCount = mouseEvent.getClickCount();
        this.mousePressed(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.getWhen(), mouseEvent.getClickCount());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.when = mouseEvent.getWhen();
        this.modifiers = mouseEvent.getModifiers();
        this.clickCount = mouseEvent.getClickCount();
        this.mouseReleased(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.getWhen(), mouseEvent.getClickCount());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.when = mouseEvent.getWhen();
        this.modifiers = mouseEvent.getModifiers();
        this.clickCount = mouseEvent.getClickCount();
        this.mouseEntered(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.when = mouseEvent.getWhen();
        this.modifiers = mouseEvent.getModifiers();
        this.clickCount = mouseEvent.getClickCount();
        this.mouseExited(mouseEvent.getX(), mouseEvent.getY());
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.when = keyEvent.getWhen();
        this.modifiers = keyEvent.getModifiers();
        this.clickCount = 0;
        if (keyEvent.isConsumed() && keyEvent.getKeyCode() == 10) {
            return;
        }
        this.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.when = keyEvent.getWhen();
        this.modifiers = keyEvent.getModifiers();
        this.clickCount = 0;
        this.keyReleased(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseDragged(int n, int n2, int n3) {
        this.currentPoint = new Point(n, n2);
        Point point = new Point(n, n2);
        JCCellPosition jCCellPosition = this.XYToCellPosition(false, true, point);
        boolean bl = false;
        if (this.table.allow_cell_resize != 0) {
            bl = this.resize(n, n2, "MOVE");
        }
        if (!bl) {
            if (this.lastPoint == null) {
                this.lastPoint = new Point(n, n2);
            }
            if (jCCellPosition != null && this.initialCell != null) {
                if (this.autoscrolling) {
                    this.stopAutoScroll(true);
                }
                if (this.sorting) {
                    this.selecting = false;
                } else if (this.dragging) {
                    this.selecting = false;
                    this.doDrag(jCCellPosition);
                } else if (!jCCellPosition.equals(this.initialCell) && !this.selecting) {
                    this.selecting = false;
                    if (this.table.selection_policy == 2 || this.table.selection_policy == 3 || this.table.selection_policy == 1 && this.initialCell.row != -1 && this.initialCell.column != -1) {
                        this.selecting = true;
                        this.select(this.initialPoint.x, this.initialPoint.y, "START");
                    }
                }
            } else if (jCCellPosition == null) {
                if (this.lastPoint.y != point.y && InputHandler.IS_AUTO_SCROLL_ROW(this.table)) {
                    this.auto_scroll_vert = true;
                    if (n2 < this.table.clip.location().y) {
                        this.auto_scroll_vert_direction = -1;
                    } else if (n2 > this.table.getRowPixelHeight(-1) + this.table.frozenRowHeight() + this.table.cell_height) {
                        this.auto_scroll_vert_direction = 1;
                    } else {
                        this.auto_scroll_vert = false;
                    }
                    if (this.auto_scroll_initialCell.row == -1) {
                        this.auto_scroll_vert = false;
                    }
                }
                if (this.lastPoint.x != point.x && InputHandler.IS_AUTO_SCROLL_COLUMN(this.table)) {
                    this.auto_scroll_horiz = true;
                    if (n < this.table.clip.location().x) {
                        this.auto_scroll_horiz_direction = -1;
                    } else if (n > this.table.getColumnPixelWidth(-1) + this.table.frozenColumnWidth() + this.table.cell_width) {
                        this.auto_scroll_horiz_direction = 1;
                    } else {
                        this.auto_scroll_horiz = false;
                    }
                    if (this.auto_scroll_initialCell.column == -1) {
                        this.auto_scroll_horiz = false;
                    }
                }
                if (this.auto_scroll_vert || this.auto_scroll_horiz) {
                    this.startAutoScroll();
                }
            } else if (this.initialCell == null && this.autoscrolling) {
                this.stopAutoScroll(true);
            }
            if (this.selecting && (this.table.selection_policy == 2 || this.table.selection_policy == 3)) {
                this.select(n, n2, "EXTEND");
            }
        }
        this.lastPoint = point;
    }

    public void mouseMoved(int n, int n2, int n3) {
        CellRenderer cellRenderer;
        int n4;
        this.currentPoint = new Point(n, n2);
        int n5 = DEFAULT_CURSOR;
        Point point = new Point(n, n2);
        JCCellPosition jCCellPosition = this.XYToCell(false, true, point);
        if (jCCellPosition == null) {
            return;
        }
        int n6 = jCCellPosition.row;
        int n7 = jCCellPosition.column;
        if (Widget.getComponent(this.table, n6, n7, false) != null) {
            this.setCursor(DEFAULT_CURSOR);
            return;
        }
        n5 = this.table.IS_TRAVERSABLE(n6, n7) ? TRAV_CURSOR : NONTRAV_CURSOR;
        if (!InputHandler.RESIZING_HEIGHT(this.table) && !InputHandler.RESIZING_WIDTH(this.table) && this.table.allow_cell_resize != 0 && (n4 = this.trackResizeCursor(n, n2)) != NULL_CURSOR) {
            n5 = n4;
        }
        if (n5 == TRAV_CURSOR && this.table.dataView.trackJCStringURL() && (cellRenderer = this.table.dataView.getCellRenderer(n6, n7)) instanceof JCStringCellRenderer) {
            Point point2 = new Point(n, n2);
            this.XYToCell(true, true, point2);
            Object object = this.table.dataView.getCellData(n6, n7);
            JCString jCString = null;
            if (object instanceof JCString) {
                jCString = (JCString)object;
            } else if (object instanceof JCStringCellData) {
                jCString = (JCString)((JCStringCellData)object).getData();
            }
            if (jCString != null && jCString.getURL(point2.x - this.table.margin_width, point2.y - this.table.margin_height) != null) {
                n5 = MOVE_CURSOR;
            }
        }
        if (!this.dragging) {
            this.setCursor(n5);
        }
    }

    public void mousePressed(int n, int n2, int n3, long l, int n4) {
        if (this.dragging) {
            return;
        }
        this.initialCell = this.XYToCellPosition(n, n2);
        this.initialPoint = new Point(n, n2);
        if (this.initialCell != null) {
            this.auto_scroll_initialCell = this.initialCell;
            this.auto_scroll_initialPoint = this.initialPoint;
        }
        boolean bl = false;
        if (this.table.allow_cell_resize != 0) {
            bl = this.resize(n, n2, "START");
        }
        if (this.initialCell == null) {
            this.endDrag();
            return;
        }
        this.selecting = false;
        this.extended = false;
        this.menu = false;
        LabelTrigger labelTrigger = null;
        if (!bl && this.initialCell != null && (labelTrigger = this.initialCell.row == -1 ? this.table.getColumnTrigger(n3) : (this.initialCell.column == -1 ? this.table.getRowTrigger(n3) : this.table.getCellTrigger(n3))) != null) {
            int n5 = labelTrigger.getAction();
            if (this.initialCell.row == -1 || this.initialCell.column == -1) {
                if (n5 == 3) {
                    this.menu = true;
                    if (this.initialCell.row == -1 && Select.isSelected(this.table, -1, this.initialCell.column) || this.initialCell.column == -1 && Select.isSelected(this.table, this.initialCell.row, -1)) {
                        return;
                    }
                    labelTrigger = null;
                } else {
                    if (this.initialCell.row == -1 && n5 == 1) {
                        this.sorting = true;
                        return;
                    }
                    if (n5 == 2) {
                        if (this.table.span.span_list.size() != 0) {
                            return;
                        }
                        this.dragging = true;
                        if (this.table.editHandler.getCellEditor() != null) {
                            this.table.editHandler.cancel();
                        }
                        this.table.clearSelectedCells();
                        this.doDrag(this.initialCell);
                        return;
                    }
                }
            } else if (n5 == 3) {
                this.menu = true;
                labelTrigger = null;
            }
        }
        this.sorting = false;
        this.dragging = false;
        if (!bl) {
            this.traverse(n, n2, "PRESS");
            if (labelTrigger != null && labelTrigger.getAction() == 0) {
                if (!(this.table.selection_policy != 2 && this.table.selection_policy != 3 || this.initialCell.row != -1 && this.initialCell.column != -1)) {
                    this.select(n, n2, "START");
                    this.selecting = true;
                }
                return;
            }
            if (InputHandler.isShift(n3)) {
                if (this.table.selection_policy == 2 || this.table.selection_policy == 3) {
                    this.select(n, n2, "EXTEND");
                    this.selecting = true;
                }
                return;
            }
            if (InputHandler.isControl(n3)) {
                if (this.table.selection_policy == 3) {
                    this.select(n, n2, "ADD");
                    this.selecting = true;
                }
                return;
            }
            if (this.table.mode == 1 || (this.table.selection_policy == 2 || this.table.selection_policy == 3) && (this.initialCell.row == -1 || this.initialCell.column == -1)) {
                this.select(n, n2, "START");
                this.selecting = true;
            }
        }
    }

    public void mouseReleased(int n, int n2, int n3, long l, int n4) {
        this.upPoint = new Point(n, n2);
        Point point = new Point(n, n2);
        JCCellPosition jCCellPosition = this.XYToCellPosition(false, true, point);
        this.initialEvent = new BaseInitialEvent(n, n2, n3);
        boolean bl = false;
        if (this.autoscrolling) {
            this.stopAutoScroll(true);
        }
        if (this.extended) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = bl2 = InputHandler.RESIZING_HEIGHT(this.table) || InputHandler.RESIZING_WIDTH(this.table);
        if (this.table.allow_cell_resize != 0) {
            bl = this.resize(n, n2, "END");
        }
        if (!bl2) {
            if (jCCellPosition != null) {
                if (this.sorting) {
                    this.setCursor(WAIT_CURSOR);
                    int n5 = this.table.dataView.getDataColumn(jCCellPosition.column);
                    int n6 = 0;
                    if (this.table.sort_column == n5 && this.table.sort_direction == 0) {
                        n6 = 1;
                    }
                    Sort.sortByColumn(this.table, n5, n6, null);
                    this.setCursor(TRAV_CURSOR);
                    this.sorting = false;
                } else if (this.dragging) {
                    int n7 = jCCellPosition.row;
                    if (jCCellPosition.row > this.initialCell.row) {
                        ++n7;
                    }
                    int n8 = jCCellPosition.column;
                    if (jCCellPosition.column > this.initialCell.column) {
                        ++n8;
                    }
                    this.endDrag();
                    if (this.initialCell.row == -1) {
                        if (this.initialCell.column != jCCellPosition.column) {
                            this.table.dragColumn(this.initialCell.column, n8);
                        }
                    } else if (this.initialCell.row != jCCellPosition.row) {
                        this.table.dragRow(this.initialCell.row, n7);
                    }
                } else if ((jCCellPosition.row == -1 || jCCellPosition.column == -1) && this.table.selection_policy != 0) {
                    this.select(n, n2, "END");
                    this.selecting = true;
                } else if (!this.selecting && !this.table.IS_TRAVERSABLE(jCCellPosition.row, jCCellPosition.column) && this.table.selection_policy != 0) {
                    this.select(n, n2, "START");
                    this.select(n, n2, "END");
                    this.selecting = true;
                } else if (this.selecting && this.table.selection_policy != 0) {
                    this.select(n, n2, "END");
                } else if (this.initialCell != null && !this.menu && this.save_row == jCCellPosition.row && this.save_column == jCCellPosition.column && this.getEditable(jCCellPosition.row, jCCellPosition.column) && this.table.dataView.getCellEditor(jCCellPosition.row, jCCellPosition.column) != null) {
                    this.traverse(n, n2, "POINTER");
                    this.select(n, n2, "CANCEL");
                    return;
                }
            } else if (this.dragging) {
                this.endDrag();
            } else if (this.selecting) {
                this.select(n, n2, "END");
            }
        }
        this.sorting = false;
        this.dragging = false;
        if (!(jCCellPosition == null || bl2 || this.initialCell == null || this.initialCell.row != jCCellPosition.row || this.initialCell.column != jCCellPosition.column || ((this.table.selection_policy != 2 || InputHandler.isShift(n3)) && (this.table.selection_policy != 3 || InputHandler.isShift(n3) || InputHandler.isControl(n3)) || this.menu && this.table.isSelected(jCCellPosition.row, jCCellPosition.column)) && (this.table.selection_policy != 1 || this.table.mode == 1 || this.initialCell.row == -1 || this.initialCell.column == -1))) {
            if (!this.selecting) {
                this.select(n, n2, "START");
            }
            this.select(n, n2, "END");
            this.selecting = true;
        }
        if (this.menu) {
            this.menu = false;
            this.table.showPopupMenu(n, n2);
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    public void mouseEntered(int n, int n2) {
        new Point(n, n2);
    }

    public void mouseExited(int n, int n2) {
        if (!InputHandler.RESIZING_HEIGHT(this.table) && !InputHandler.RESIZING_WIDTH(this.table)) {
            this.setCursor(DEFAULT_CURSOR);
        }
    }

    public void keyPressed(int n, int n2) {
        KeyModifier[] keyModifierArray;
        Object object;
        if (!this.table.repaint) {
            return;
        }
        int n3 = this.getCopyPasteKey(n, n2);
        if (n3 != -999) {
            this.doCopyPaste(n3);
            return;
        }
        if (this.table.editHandler.editor != null && (object = this.table.editHandler.editor.getReservedKeys()) != null && ((KeyModifier[])object).length > 0) {
            int n4 = 0;
            while (n4 < ((KeyModifier[])object).length) {
                if (object[n4] != null && object[n4].match(n, n2) && !this.containerReserved((KeyModifier)object[n4])) {
                    return;
                }
                ++n4;
            }
        }
        this.initialEvent = new BaseInitialEvent(n, n2);
        if (this.table.edit_row >= 0 && this.table.edit_column >= 0 && (object = this.table.dataView.getCellEditor(this.table.edit_row, this.table.edit_column)) != null && (keyModifierArray = object.getReservedKeys()) != null && keyModifierArray.length > 0) {
            int n5 = 0;
            while (n5 < keyModifierArray.length) {
                if (keyModifierArray[n5] != null && keyModifierArray[n5].match(n, n2) && keyModifierArray[n5].canInitializeEdit && !this.containerReserved(keyModifierArray[n5])) {
                    this.table.editHandler.traverse(this.table.edit_row, this.table.edit_column, true, this.initialEvent, null, true);
                    return;
                }
                ++n5;
            }
        }
        if (n == 36) {
            if (InputHandler.isControl(n2)) {
                this.traverse(0, 0, "CTRLHOME");
                return;
            }
        } else {
            if (n == 34 && InputHandler.isControl(n2)) {
                this.traverse(0, 0, "CTRLPAGEDOWN");
                return;
            }
            if (n == 35) {
                if (InputHandler.isControl(n2)) {
                    this.traverse(0, 0, "CTRLEND");
                    return;
                }
            } else {
                if (n == 33 && InputHandler.isControl(n2)) {
                    this.traverse(0, 0, "CTRLPAGEUP");
                    return;
                }
                if (n == 34) {
                    this.traverse(0, 0, "PAGEDOWN");
                    return;
                }
                if (n == 33) {
                    this.traverse(0, 0, "PAGEUP");
                    return;
                }
                if (n == 27) {
                    this.resize(0, 0, "CANCEL");
                    this.select(0, 0, "CANCEL");
                    return;
                }
                if (n == 10 && this.table.editHandler.editor != null) {
                    this.table.editHandler.commit();
                    return;
                }
                if (this.table.edit_row >= 0) {
                    boolean bl = false;
                    if (n == 9) {
                        if (InputHandler.isShift(n2)) {
                            this.traverse(0, 0, "LEFT");
                        } else {
                            this.traverse(0, 0, "RIGHT");
                        }
                        bl = true;
                        return;
                    }
                    if (n == 38) {
                        this.traverse(0, 0, "UP");
                        return;
                    }
                    if (n == 40) {
                        this.traverse(0, 0, "DOWN");
                        return;
                    }
                    if (n == 37) {
                        this.traverse(0, 0, "LEFT");
                        return;
                    }
                    if (n == 39) {
                        this.traverse(0, 0, "RIGHT");
                        return;
                    }
                    if (!this.table.hasText()) {
                        this.table.editHandler.traverse(this.table.edit_row, this.table.edit_column, false, this.initialEvent, null, true);
                        return;
                    }
                } else if (this.table.mode == 1) {
                    if (n == 40) {
                        this.select(0, 0, "NEXTROW");
                        return;
                    }
                    if (n == 38) {
                        this.select(0, 0, "PREVROW");
                    }
                }
            }
        }
    }

    public void keyReleased(int n, int n2) {
    }

    public void setCursor(int n) {
        if (this.table.getTrackCursor() || this.table.cursor == -999) {
            int n2 = 0;
            while (n2 < this.table.clip_list.length) {
                this.table.clip_list[n2].setCursor(Cursor.getPredefinedCursor(n));
                ++n2;
            }
        }
    }

    private int trackResizeCursor(int n, int n2) {
        if (!this.table.getTrackCursor()) {
            return NONTRAV_CURSOR;
        }
        Clip clip = this.getClip(n, n2);
        int n3 = DEFAULT_CURSOR;
        Point point = new Point(n, n2);
        JCCellPosition jCCellPosition = this.XYToCell(false, true, point);
        if (jCCellPosition == null) {
            return NULL_CURSOR;
        }
        int n4 = jCCellPosition.row;
        int n5 = jCCellPosition.column;
        n = point.x;
        n2 = point.y;
        if (this.getResizePosition(clip, n4, n5, n, n2)) {
            n3 = this.table.allow_cell_resize == 0 ? (this.table.IS_TRAVERSABLE(n4, n5) ? TRAV_CURSOR : NONTRAV_CURSOR) : (this.resize_row != -999 && this.resize_column != -999 ? CORNER_CURSOR : (this.resize_row != -999 ? VERT_CURSOR : HORIZ_CURSOR));
        }
        if (n3 != DEFAULT_CURSOR) {
            return n3;
        }
        return NULL_CURSOR;
    }

    boolean getResizePosition(Clip clip, int n, int n2, int n3, int n4) {
        if (clip == null || this.table.rows == 0 || this.table.columns == 0) {
            return false;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = Math.max(4, this.table.shadow_thickness);
        boolean bl = false;
        this.resize_row = -999;
        this.resize_column = -999;
        if (this.table.span.doSpansExist() && this.table.span.find(n, n2, this.span, null) != -999) {
            bl = true;
            n5 = this.span.end_row;
            n6 = this.span.end_column;
        }
        n3 += clip.xOffset();
        n4 += clip.yOffset();
        int n8 = 0;
        if (Table.isColumnLabel(n, n2)) {
            if (!(bl && this.span.start_column != n2 || Math.abs(n3 - this.table.columnPosition(n2)) >= n7)) {
                if (n2 == 0 && this.table.frozen_columns > 0 & this.table.frozen_column_placement == 2) {
                    this.cancelResize();
                } else if (n2 == this.table.frozen_columns && this.table.frozen_column_placement == 2) {
                    this.cancelResize();
                } else {
                    int n9 = n2 - 1;
                    while (n9 >= 0 && this.table.columnWidth(n9) == 0) {
                        --n9;
                    }
                    if (n9 >= 0) {
                        this.resize_column = n9;
                        n8 |= 1;
                    }
                }
            } else if (n6 < this.table.columns - 1 && this.table.columnPosition(n6 + 1) - n3 < n7) {
                this.resize_column = n6;
                n8 |= 8;
            } else if (n6 == this.table.columns - 1 && this.table.columnPosition(n6) + this.table.columnWidth(n6) - n3 < n7) {
                this.resize_column = n6;
                n8 |= 8;
            } else if (this.table.column_label_height > 0 && Math.abs(this.table.columnLabelHeight() - n4) < n7) {
                this.resize_row = n;
                n8 |= 4;
            }
        } else if (Table.isRowLabel(n, n2)) {
            if (!(bl && this.span.start_row != n || Math.abs(n4 - this.table.rowPosition(n)) >= n7)) {
                if (n == 0 && this.table.frozen_rows > 0 & this.table.frozen_row_placement == 6) {
                    this.cancelResize();
                } else if (n == this.table.frozen_rows && this.table.frozen_row_placement == 6) {
                    this.cancelResize();
                } else {
                    int n10 = n - 1;
                    while (n10 >= 0 && this.table.rowHeight(n10) == 0) {
                        --n10;
                    }
                    if (n10 >= 0) {
                        this.resize_row = n10;
                        n8 |= 2;
                    }
                }
            } else if (n5 < this.table.rows - 1 && this.table.rowPosition(n5 + 1) - n4 < n7) {
                this.resize_row = n5;
                n8 |= 4;
            } else if (n5 == this.table.rows - 1 && this.table.rowPosition(n5) + this.table.rowHeight(n5) - n4 < n7) {
                this.resize_row = n5;
                n8 |= 4;
            } else if (this.table.row_label_width > 0 && Math.abs(this.table.rowLabelWidth() - n3) < n7) {
                this.resize_column = n2;
                n8 |= 8;
            }
        } else if (!this.table.resize_by_labels_only) {
            if (!(bl && this.span.start_column != n2 || Math.abs(n3 - this.table.columnPosition(n2)) >= n7)) {
                if (n2 == 0 && this.table.frozen_columns > 0 && this.table.frozen_column_placement == 2) {
                    this.cancelResize();
                } else if (n2 == this.table.frozen_columns && this.table.frozen_column_placement == 2 && this.table.row_label_width > 0) {
                    this.resize_column = -1;
                } else {
                    int n11 = n2 - 1;
                    while (n11 >= 0 && this.table.columnWidth(n11) == 0) {
                        --n11;
                    }
                    if (n11 >= 0) {
                        this.resize_column = n11;
                        n8 |= 1;
                    } else if (this.table.row_label_width > 0 && InputHandler.isFrozen(this.table, n, n2) && this.table.frozen_column_placement == 0) {
                        this.resize_column = -1;
                        n8 |= 1;
                    }
                }
            } else if (n6 < this.table.columns - 1 && this.table.columnPosition(n6 + 1) - n3 < n7) {
                this.resize_column = n6;
                n8 |= 8;
            } else if (n6 == this.table.columns - 1 && this.table.columnPosition(n6) + this.table.columnWidth(n6) - n3 < n7) {
                this.resize_column = n6;
                n8 |= 8;
            }
            if (!(bl && this.span.start_row != n || Math.abs(n4 - this.table.rowPosition(n)) >= n7)) {
                if (n == 0 && this.table.frozen_rows > 0 & this.table.frozen_row_placement == 6) {
                    this.cancelResize();
                } else if (n == this.table.frozen_rows && this.table.frozen_row_placement == 6 && this.table.column_label_height > 0) {
                    this.resize_row = -1;
                } else {
                    int n12 = n - 1;
                    while (n12 >= 0 && this.table.rowHeight(n12) == 0) {
                        --n12;
                    }
                    if (n12 >= 0) {
                        this.resize_row = n12;
                        n8 |= 2;
                    } else if (this.table.column_label_height > 0 && InputHandler.isFrozen(this.table, n, n2)) {
                        this.resize_row = -1;
                        n8 |= 2;
                    }
                }
            } else if (n5 < this.table.rows - 1 && this.table.rowPosition(n5 + 1) - n4 < n7) {
                this.resize_row = n5;
                n8 |= 4;
            } else if (n5 == this.table.rows - 1 && this.table.rowPosition(n5) + this.table.rowHeight(n5) - n4 < n7) {
                this.resize_row = n5;
                n8 |= 4;
            }
        }
        if (this.table.allow_cell_resize == 4) {
            this.resize_column = -999;
        }
        if (this.table.allow_cell_resize == 2) {
            this.resize_row = -999;
        }
        return this.resize_row != -999 || this.resize_column != -999;
    }

    public static boolean isFrozen(Table table, int n, int n2) {
        return n < table.frozen_rows || n2 < table.frozen_columns;
    }

    private boolean resize(int n, int n2, String string) {
        Point point;
        JCCellPosition jCCellPosition;
        int n3;
        Clip clip = null;
        if (this.prevParam == null) {
            this.prevParam = "";
        }
        if (string.equals("START") && this.prevParam.equals("MOVE")) {
            return true;
        }
        if (string.equals("END") && this.prevParam.equals("END")) {
            return true;
        }
        if (string.equals("START") && this.prevParam.equals("START")) {
            return true;
        }
        this.prevParam = string;
        Clip clip2 = this.getClip(n, n2);
        if (clip2 != null) {
            this.clip = clip2;
        }
        if (this.clip == null || this.table.allow_cell_resize == 0) {
            this.cancelResize();
            this.clip = null;
            return false;
        }
        if (!(string.equals("START") || n >= 0 && n2 >= 0)) {
            int n4 = this.clip.location().x;
            n3 = this.clip.location().y;
            if (InputHandler.RESIZING_WIDTH(this.table) && n < 0) {
                int n5 = 0;
                while (n5 < this.table.clip_list.length) {
                    clip = this.table.clip_list[n5];
                    if (clip.location().x + clip.size().width == n4) break;
                    ++n5;
                }
                if (n5 < this.table.clip_list.length) {
                    n = n + n4 - clip.location().x;
                    this.clip = clip;
                }
            } else if (InputHandler.RESIZING_HEIGHT(this.table) && n2 < 0) {
                int n6 = 0;
                while (n6 < this.table.clip_list.length) {
                    clip = this.table.clip_list[n6];
                    if (clip.location().y + clip.size().height == n3) break;
                    ++n6;
                }
                if (n6 < this.table.clip_list.length) {
                    n2 = n2 + n3 - clip.location().y;
                    this.clip = clip;
                }
            }
        }
        if ((jCCellPosition = this.XYToCell(false, true, point = new Point(n, n2))) == null && (jCCellPosition = this.oldPos) == null) {
            return false;
        }
        this.oldPos = jCCellPosition;
        if (jCCellPosition == null) {
            return true;
        }
        int n7 = jCCellPosition.row;
        int n8 = jCCellPosition.column;
        n = point.x;
        n2 = point.y;
        if (!(string.equals("START") || InputHandler.RESIZING_HEIGHT(this.table) || InputHandler.RESIZING_WIDTH(this.table))) {
            this.setCursor(DEFAULT_CURSOR);
            this.cancelResize();
            this.clip = null;
            return false;
        }
        if ((InputHandler.RESIZING_HEIGHT(this.table) || InputHandler.RESIZING_WIDTH(this.table)) && (string.equals("CANCEL") || string.equals("END"))) {
            this.setCursor(DEFAULT_CURSOR);
        }
        if (string.equals("START")) {
            this.clip.suspend_paint = true;
            this.table.resize_row = -999;
            this.table.resize_column = -999;
            if (this.table.allow_cell_resize == 0) {
                this.cancelResize();
                this.clip = null;
                return false;
            }
            if (!this.getResizePosition(this.clip, n7, n8, n, n2)) {
                this.cancelResize();
                this.clip = null;
                return false;
            }
            JCResizeCellEvent jCResizeCellEvent = new JCResizeCellEvent(this.table, 1, this.resize_row, this.resize_column, string, InputHandler.CURRENT_WIDTH(this.table, this.resize_column), InputHandler.CURRENT_HEIGHT(this.table, this.resize_row));
            this.table.fireJCResizeCellEvent(jCResizeCellEvent);
            if (!jCResizeCellEvent.doit) {
                this.cancelResize();
                this.clip = null;
                return false;
            }
            this.table.resize_row = this.resize_row;
            this.table.resize_column = this.resize_column;
            if (InputHandler.RESIZING_WIDTH(this.table) && InputHandler.RESIZING_HEIGHT(this.table)) {
                this.setCursor(CORNER_CURSOR);
            } else if (InputHandler.RESIZING_WIDTH(this.table)) {
                this.setCursor(HORIZ_CURSOR);
            } else if (InputHandler.RESIZING_HEIGHT(this.table)) {
                this.setCursor(VERT_CURSOR);
            }
            this.drawLine(false, this.currentPoint.x, this.currentPoint.y);
        } else if (string.equals("MOVE")) {
            if (InputHandler.RESIZING_HEIGHT(this.table)) {
                InputHandler.ROW_POS(this.table, this.clip);
            }
            if (InputHandler.RESIZING_WIDTH(this.table)) {
                InputHandler.COLUMN_POS(this.table, this.clip);
            }
            this.drawLine(true, 0, 0);
            this.drawLine(false, this.currentPoint.x, this.currentPoint.y);
        } else if (string.equals("CANCEL")) {
            this.clip.suspend_paint = false;
            this.drawLine(true, 0, 0);
            this.cancelResize();
            this.clip = null;
        } else if (string.equals("END")) {
            int n9;
            int n10;
            this.clip.suspend_paint = false;
            int n11 = 0;
            int n12 = 0;
            this.drawLine(true, 0, 0);
            if (InputHandler.RESIZING_HEIGHT(this.table)) {
                n12 = this.initialPoint.y - this.upPoint.y;
                n10 = InputHandler.CURRENT_HEIGHT(this.table, n7) - n12;
                n10 = Math.max(n10, this.table.shadow_thickness + 4);
                n12 = InputHandler.CURRENT_HEIGHT(this.table, n7) - n10;
            } else {
                n10 = InputHandler.CURRENT_HEIGHT(this.table, n7);
            }
            if (InputHandler.RESIZING_WIDTH(this.table)) {
                n11 = this.initialPoint.x - this.upPoint.x;
                n9 = InputHandler.CURRENT_WIDTH(this.table, n8) - n11;
                n9 = Math.max(n9, this.table.shadow_thickness + 4);
                n11 = InputHandler.CURRENT_WIDTH(this.table, n8) - n9;
            } else {
                n9 = InputHandler.CURRENT_WIDTH(this.table, n8);
            }
            if (Math.abs(n12) < 4 && Math.abs(n11) < 4) {
                if (this.table.resizeCellListeners != null) {
                    JCResizeCellEvent jCResizeCellEvent = new JCResizeCellEvent(this.table, 2, this.table.resize_row, this.table.resize_column, "CANCEL", InputHandler.CURRENT_WIDTH(this.table, this.table.resize_column), InputHandler.CURRENT_HEIGHT(this.table, this.table.resize_row));
                    jCResizeCellEvent.new_column_width = InputHandler.CURRENT_WIDTH(this.table, this.table.resize_column);
                    jCResizeCellEvent.new_row_height = InputHandler.CURRENT_HEIGHT(this.table, this.table.resize_row);
                    this.table.fireJCResizeCellEvent(jCResizeCellEvent);
                }
                this.cancelResize();
                this.clip = null;
                return false;
            }
            JCResizeCellEvent jCResizeCellEvent = new JCResizeCellEvent(this.table, 2, this.table.resize_row, this.table.resize_column, string, InputHandler.CURRENT_WIDTH(this.table, this.table.resize_column), InputHandler.CURRENT_HEIGHT(this.table, this.table.resize_row));
            jCResizeCellEvent.new_row_height = InputHandler.RESIZING_HEIGHT(this.table) ? n10 : -999;
            jCResizeCellEvent.new_column_width = InputHandler.RESIZING_WIDTH(this.table) ? n9 : -999;
            this.table.fireJCResizeCellEvent(jCResizeCellEvent);
            if (!jCResizeCellEvent.doit) {
                this.cancelResize();
                this.clip = null;
                return false;
            }
            n10 = jCResizeCellEvent.new_row_height;
            n9 = jCResizeCellEvent.new_column_width;
            if (InputHandler.RESIZING_HEIGHT(this.table) || InputHandler.RESIZING_WIDTH(this.table)) {
                n3 = 0;
                this.table.set_property = false;
                if (InputHandler.RESIZING_HEIGHT(this.table)) {
                    if (this.table.resize_row != -1 && this.table.getResizeEven()) {
                        this.table.setPixelHeight(-997, n10);
                    } else {
                        this.table.setPixelHeight(this.table.resize_row, n10);
                    }
                    n3 |= this.table.property_flags;
                }
                if (InputHandler.RESIZING_WIDTH(this.table)) {
                    if (this.table.resize_column != -1 && this.table.getResizeEven()) {
                        this.table.setPixelWidth(-997, n9);
                    } else {
                        this.table.setPixelWidth(this.table.resize_column, n9);
                    }
                    n3 |= this.table.property_flags;
                }
                this.table.set_property = true;
                this.table.setProperty(n3);
            }
            this.cancelResize();
            this.clip = null;
            this.setCursor(DEFAULT_CURSOR);
        }
        return true;
    }

    private void cancelResize() {
        if (this.resize_column != -999 || this.resize_row != -999) {
            this.table.resize_row = -999;
            this.table.resize_column = -999;
            this.resize_row = -999;
            this.resize_column = -999;
            this.setCursor(DEFAULT_CURSOR);
        }
    }

    private void drawLine(boolean bl, int n, int n2) {
        Graphics graphics;
        Clip clip;
        int n3;
        boolean bl2 = JCEnvironment.isJBuilder();
        if (bl && bl2) {
            return;
        }
        if (!bl) {
            this.x_save = n;
            this.y_save = n2;
        }
        if (n == -999 || n2 == -999 || this.table.clip_list == null) {
            return;
        }
        if (bl2) {
            this.table.repaint();
        }
        if (InputHandler.RESIZING_HEIGHT(this.table)) {
            n3 = 0;
            while (n3 < this.table.clip_list.length) {
                clip = this.table.clip_list[n3];
                n2 = this.y_save - clip.location().y;
                graphics = clip.getGraphics();
                if (!bl2) {
                    graphics.setXORMode(Color.lightGray);
                }
                graphics.drawLine(0, n2, clip.size().width, n2);
                graphics.dispose();
                ++n3;
            }
        }
        if (InputHandler.RESIZING_WIDTH(this.table)) {
            n3 = 0;
            while (n3 < this.table.clip_list.length) {
                clip = this.table.clip_list[n3];
                n = this.x_save - clip.location().x;
                graphics = clip.getGraphics();
                if (!bl2) {
                    graphics.setXORMode(Color.lightGray);
                }
                graphics.drawLine(n, 0, n, clip.size().height);
                graphics.dispose();
                ++n3;
            }
        }
    }

    boolean select(int n, int n2, String string) {
        if (!this.table.allow_select) {
            this.table.allow_select = true;
            this.table.select_last_row = -1000;
            return false;
        }
        if (!this.table.repaint) {
            return false;
        }
        if (string.equals("CANCEL")) {
            Select.deselectAll(this.table);
            return false;
        }
        if (string.equals("END")) {
            this.table.editHandler.commit();
        }
        if (InputHandler.RESIZING_HEIGHT(this.table) || InputHandler.RESIZING_WIDTH(this.table)) {
            return false;
        }
        if (this.table.selection_policy == 0) {
            return false;
        }
        int n3 = -999;
        int n4 = -999;
        String string2 = new String(string);
        if (string.equals("CURRENT")) {
            n3 = this.table.edit_row;
            n4 = this.table.edit_column;
            string = "START";
        } else {
            if ((string.equals("EXTEND") || string.equals("END")) && this.table.select_last_row == -1000) {
                return false;
            }
            if (string.equals("DOWN") || string.equals("UP")) {
                if (this.table.rows == 0) {
                    return false;
                }
                if (this.table.selected_cells.size() > 0) {
                    JCCellRange jCCellRange = (JCCellRange)this.table.selected_cells.elementAt(this.table.selected_cells.size() - 1);
                    if (string.equals("DOWN")) {
                        n3 = jCCellRange.end_row + 1;
                        if (n3 == this.table.rows - 1) {
                            return false;
                        }
                        n4 = jCCellRange.end_column;
                        string = "EXTEND";
                    } else if (string.equals("UP")) {
                        n3 = jCCellRange.end_row - 1;
                        if (n3 < 0) {
                            return false;
                        }
                        n4 = jCCellRange.end_column;
                        string = "EXTEND";
                    }
                }
            } else if (!string.equals("NEXTROW") && !string.equals("PREVROW")) {
                Point point = new Point(n, n2);
                JCCellPosition jCCellPosition = this.XYToCell(true, false, point);
                if (jCCellPosition == null && !string.equals("END")) {
                    return false;
                }
                if (jCCellPosition != null) {
                    n3 = jCCellPosition.row;
                    n4 = jCCellPosition.column;
                }
            } else {
                int n5 = this.table.rows;
                int n6 = -1;
                if (this.table.rows == 0) {
                    return false;
                }
                if (this.table.selected_cells.size() > 0) {
                    int n7 = 0;
                    while (n7 < this.table.selected_cells.size()) {
                        JCCellRange jCCellRange = (JCCellRange)this.table.selected_cells.elementAt(n7);
                        n5 = Math.min(n5, jCCellRange.start_row);
                        n6 = Math.max(n6, jCCellRange.end_row);
                        ++n7;
                    }
                }
                if (string.equals("PREVROW")) {
                    if (n5 == 0) {
                        return false;
                    }
                    n3 = n5 - 1;
                } else if (string.equals("NEXTROW")) {
                    if (n6 == this.table.rows - 1) {
                        return false;
                    }
                    n3 = n6 + 1;
                }
                n4 = -998;
                string = "START";
            }
        }
        int n8 = this.table.selection_policy;
        JCSelectEvent jCSelectEvent = null;
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 1, n3, n4, string, this.when, this.modifiers, this.clickCount);
        }
        if ((Table.isColumnLabel(n3, n4) || Table.isRowLabel(n3, n4) && !InputHandler.IS_LISTMODE(this.table)) && (n8 == 1 || InputHandler.IS_LISTMODE(this.table)) && InputHandler.IS_LISTMODE(this.table) && !string.equals("START") && string.equals("END")) {
            this.exit(string, string2, jCSelectEvent);
            return true;
        }
        if (InputHandler.IS_LISTMODE(this.table) && n3 != -1) {
            n4 = -998;
            if (jCSelectEvent != null) {
                jCSelectEvent.column = -998;
            }
        }
        if (this.table.getSelectionMode() == 1 && n3 != -1) {
            n4 = -998;
            if (jCSelectEvent != null) {
                jCSelectEvent.column = -998;
            }
        }
        if (this.table.getSelectionMode() == 2 && n4 != -1) {
            n3 = -998;
            if (jCSelectEvent != null) {
                jCSelectEvent.row = -998;
            }
        }
        if (string.equals("START") || string.equals("ADD") && n8 == 3 || string.equals("EXTEND") && InputHandler.IS_LISTMODE(this.table) && n8 == 1) {
            if (string.equals("EXTEND") && (n3 == this.table.select_last_row || this.table.select_start_row == -1001)) {
                return false;
            }
            if (string.equals("START") || n8 == 1) {
                if (InputHandler.IS_LISTMODE(this.table) && n8 == 1 && n3 == this.table.select_last_row && this.table.select_start_row != -1) {
                    this.table.select_start_row = -1001;
                    this.table.select_last_row = -999;
                    return false;
                }
                if (this.table.getSelectedCells() != null && this.table.getSelectedCells().size() != 0) {
                    this.callCallback(true, 2, jCSelectEvent);
                    if (jCSelectEvent == null || jCSelectEvent.doit) {
                        Select.deselectAll(this.table);
                    }
                }
            }
            this.callCallback(true, 1, jCSelectEvent);
            if (jCSelectEvent != null && !jCSelectEvent.doit) {
                this.table.allow_select = false;
                return false;
            }
            if (!this.table.makeVisible(n3, n4)) {
                return false;
            }
            if (jCSelectEvent != null) {
                if (jCSelectEvent.row == -998 || jCSelectEvent.row == -997) {
                    n3 = -1;
                }
                if (jCSelectEvent.column == -998 || jCSelectEvent.column == -997) {
                    n4 = -1;
                }
            }
            if (jCSelectEvent == null || jCSelectEvent.doit) {
                Select.createSelectedRange(this.table, n3, n4);
            }
            this.table.select_start_row = this.table.select_last_row = n3;
            this.table.select_start_column = this.table.select_last_column = n4;
        } else if (string.equals("EXTEND") && (n8 == 2 || n8 == 3)) {
            if (this.table.selected_cells.size() == 0) {
                return false;
            }
            if (n3 == this.table.select_last_row && n4 == this.table.select_last_column) {
                return false;
            }
            if (!this.table.makeVisible(n3, n4)) {
                return false;
            }
            if (jCSelectEvent != null) {
                jCSelectEvent.stage = 1;
            }
            this.callCallback(true, 1, jCSelectEvent);
            if (jCSelectEvent != null && !jCSelectEvent.doit) {
                return false;
            }
            if (jCSelectEvent != null) {
                if (jCSelectEvent.row == -998 || jCSelectEvent.row == -997) {
                    n3 = -1;
                }
                if (jCSelectEvent.column == -998 || jCSelectEvent.column == -997) {
                    n4 = -1;
                }
            }
            Select.setSelectedRange(this.table, n3, n4);
            this.table.select_last_row = n3;
            this.table.select_last_column = n4;
        }
        this.exit(string, string2, jCSelectEvent);
        return true;
    }

    private void callCallback(boolean bl, int n, JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent == null) {
            return;
        }
        jCSelectEvent.type = bl ? 1 : 2;
        jCSelectEvent.state_change = n;
        this.table.fireJCSelectEvent(jCSelectEvent);
    }

    private void exit(String string, String string2, JCSelectEvent jCSelectEvent) {
        if (string.equals("END") || string2.equals("CURRENT") || string2.equals("PREVROW") || string2.equals("NEXTROW")) {
            Select.cleanup(this.table);
            if (jCSelectEvent != null) {
                this.callCallback(false, jCSelectEvent.state_change, jCSelectEvent);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static JCCellPosition findTraversableCell(Table var0, String var1_1, int var2_2, int var3_3) {
        block54: {
            block57: {
                block56: {
                    block55: {
                        block53: {
                            var6_4 = false;
                            if (!var0.traversable) {
                                return null;
                            }
                            if (var2_2 < 0 || var3_3 < 0) {
                                return null;
                            }
                            var4_5 = var2_2;
                            var5_6 = var3_3;
                            if (!var1_1.equals("RIGHT")) break block53;
                            var5_6 = var3_3 + 1;
                            ** GOTO lbl25
                            {
                                if (var4_5 == var2_2 && var5_6 == var3_3) {
                                    if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                                        return new JCCellPosition(var4_5, var5_6);
                                    }
                                    return null;
                                }
                                var6_4 = var0.isTraversable(var4_5, var5_6);
                                if (var6_4) {
                                    if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                                        return new JCCellPosition(var4_5, var5_6);
                                    }
                                    return null;
                                }
                                ++var5_6;
                                do {
                                    if (var5_6 < var0.columns) continue block0;
                                    var4_5 = var4_5 == var0.rows - 1 ? 0 : ++var4_5;
                                    var5_6 = 0;
lbl25:
                                    // 2 sources

                                } while (var4_5 != var2_2 || var5_6 != var3_3);
                            }
                            break block54;
                        }
                        if (!var1_1.equals("LEFT")) break block55;
                        var5_6 = var3_3 - 1;
                        ** GOTO lbl45
                        {
                            if (var4_5 == var2_2 && var5_6 == var3_3) {
                                if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                                    return new JCCellPosition(var4_5, var5_6);
                                }
                                return null;
                            }
                            var6_4 = var0.isTraversable(var4_5, var5_6);
                            if (var6_4) {
                                if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                                    return new JCCellPosition(var4_5, var5_6);
                                }
                                return null;
                            }
                            --var5_6;
                            do {
                                if (var5_6 >= 0) continue block2;
                                var4_5 = var4_5 == 0 ? var0.rows - 1 : --var4_5;
                                var5_6 = var0.columns - 1;
lbl45:
                                // 2 sources

                            } while (var4_5 != var2_2 || var5_6 != var3_3);
                        }
                        break block54;
                    }
                    if (!var1_1.equals("DOWN")) break block56;
                    var4_5 = var2_2 + 1;
                    ** GOTO lbl65
                    {
                        if (var4_5 == var2_2 && var5_6 == var3_3) {
                            if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                                return new JCCellPosition(var4_5, var5_6);
                            }
                            return null;
                        }
                        var6_4 = var0.isTraversable(var4_5, var5_6);
                        if (var6_4) {
                            if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                                return new JCCellPosition(var4_5, var5_6);
                            }
                            return null;
                        }
                        ++var4_5;
                        do {
                            if (var4_5 < var0.rows) continue block4;
                            var5_6 = var5_6 == var0.columns - 1 ? 0 : ++var5_6;
                            var4_5 = 0;
lbl65:
                            // 2 sources

                        } while (var4_5 != var2_2 || var5_6 != var3_3);
                    }
                    break block54;
                }
                if (!var1_1.equals("UP")) break block57;
                var4_5 = var2_2 - 1;
                ** GOTO lbl85
                {
                    if (var4_5 == var2_2 && var5_6 == var3_3) {
                        if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                            return new JCCellPosition(var4_5, var5_6);
                        }
                        return null;
                    }
                    var6_4 = var0.isTraversable(var4_5, var5_6);
                    if (var6_4) {
                        if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
                            return new JCCellPosition(var4_5, var5_6);
                        }
                        return null;
                    }
                    --var4_5;
                    do {
                        if (var4_5 >= 0) continue block6;
                        var5_6 = var5_6 == 0 ? var0.columns - 1 : --var5_6;
                        var4_5 = var0.rows - 1;
lbl85:
                        // 2 sources

                    } while (var4_5 != var2_2 || var5_6 != var3_3);
                }
                break block54;
            }
            if (var1_1.equals("CTRLHOME")) {
                var4_5 = 0;
                var5_6 = 0;
                if (var0.isTraversable(var4_5, var5_6)) {
                    return new JCCellPosition(var4_5, var5_6);
                }
                var4_5 = 0;
                while (var4_5 < var0.rows) {
                    var5_6 = 0;
                    while (var5_6 < var0.columns) {
                        if (var0.isTraversable(var4_5, var5_6)) {
                            return new JCCellPosition(var4_5, var5_6);
                        }
                        ++var5_6;
                    }
                    ++var4_5;
                }
                return null;
            }
            if (var1_1.equals("PAGEUP")) {
                var7_7 = var0.getVisibleCells();
                var4_5 = var0.edit_row - (var7_7.end_row - var7_7.start_row);
                var5_6 = var0.edit_column;
                if (var0.isTraversable(var4_5, var5_6)) {
                    return new JCCellPosition(var4_5, var5_6);
                }
                var4_5 = 0;
                while (var4_5 < var0.rows) {
                    if (var0.isTraversable(var4_5, var5_6)) {
                        return new JCCellPosition(var4_5, var5_6);
                    }
                    ++var4_5;
                }
                return null;
            }
            if (var1_1.equals("CTRLPAGEUP")) {
                var4_5 = 0;
                var5_6 = var0.edit_column;
                if (var0.isTraversable(var4_5, var5_6)) {
                    return new JCCellPosition(var4_5, var5_6);
                }
                var4_5 = 0;
                while (var4_5 < var0.rows) {
                    if (var0.isTraversable(var4_5, var5_6)) {
                        return new JCCellPosition(var4_5, var5_6);
                    }
                    ++var4_5;
                }
                return null;
            }
            if (var1_1.equals("PAGEDOWN")) {
                var7_8 = var0.getVisibleCells();
                var4_5 = var0.edit_row + (var7_8.end_row - var7_8.start_row);
                var5_6 = var0.edit_column;
                if (var0.isTraversable(var4_5, var5_6)) {
                    return new JCCellPosition(var4_5, var5_6);
                }
                var4_5 = 0;
                while (var4_5 < var0.rows) {
                    if (var0.isTraversable(var4_5, var5_6)) {
                        return new JCCellPosition(var4_5, var5_6);
                    }
                    ++var4_5;
                }
                return null;
            }
            if (var1_1.equals("CTRLEND")) {
                var7_9 = var0.dataView.getNumRows();
                var4_5 = var7_9 - 1;
                if (var0.isTraversable(var4_5, var5_6 = (var8_11 = var0.dataView.getNumColumns()) - 1)) {
                    return new JCCellPosition(var4_5, var5_6);
                }
                var4_5 = var7_9 - 1;
                while (var4_5 >= 0) {
                    var5_6 = var8_11 - 1;
                    while (var5_6 >= 0) {
                        if (var0.isTraversable(var4_5, var5_6)) {
                            return new JCCellPosition(var4_5, var5_6);
                        }
                        --var5_6;
                    }
                    --var4_5;
                }
                return null;
            }
            if (var1_1.equals("CTRLPAGEDOWN")) {
                var7_10 = var0.dataView.getNumRows();
                var4_5 = var7_10 - 1;
                if (var0.isTraversable(var4_5, var5_6 = var0.edit_column)) {
                    return new JCCellPosition(var4_5, var5_6);
                }
                var4_5 = var7_10 - 1;
                while (var4_5 >= 0) {
                    if (var0.isTraversable(var4_5, var5_6)) {
                        return new JCCellPosition(var4_5, var5_6);
                    }
                    --var4_5;
                }
                return null;
            }
        }
        if (var6_4 || var0.isTraversable(var4_5, var5_6)) {
            return new JCCellPosition(var4_5, var5_6);
        }
        return null;
    }

    boolean traverse(int n, int n2, String string) {
        if (!this.table.traversable) {
            return false;
        }
        Table table = this.table;
        int n3 = table.edit_row;
        int n4 = table.edit_column;
        if (this.table.resize_row != -999 || this.table.resize_column != -999) {
            return false;
        }
        if (string.equals("POINTER") || string.equals("PRESS")) {
            Point point = new Point(n, n2);
            JCCellPosition jCCellPosition = this.XYToCell(true, true, point);
            if (jCCellPosition == null) {
                return false;
            }
            n3 = jCCellPosition.row;
            n4 = jCCellPosition.column;
            if (Table.isLabel(n3, n4)) {
                return true;
            }
            if (!this.table.editHandler.commit()) {
                return false;
            }
            if (!string.equals("PRESS")) {
                this.table.editHandler.traverse(n3, n4, false, this.initialEvent, string, !this.menu);
            } else {
                if (this.table.traverseCellListeners != null) {
                    JCTraverseCellEvent jCTraverseCellEvent = new JCTraverseCellEvent(this.table, this.save_row, this.save_column, n3, n4, "POINTER");
                    this.table.fireJCTraverseCellEvent(jCTraverseCellEvent);
                    n3 = jCTraverseCellEvent.next_row;
                    n4 = jCTraverseCellEvent.next_column;
                }
                if (this.table.isTraverseAllowed(n3, n4)) {
                    this.save_row = n3;
                    this.save_column = n4;
                    this.table.editHandler.traverse(n3, n4, false, this.initialEvent, string, false);
                }
            }
        } else {
            JCCellPosition jCCellPosition = InputHandler.findTraversableCell(this.table, string, n3, n4);
            if (jCCellPosition == null) {
                return false;
            }
            if (!this.table.traverseCycle) {
                if (string.equals("RIGHT") && (n3 != jCCellPosition.row || jCCellPosition.column < n4)) {
                    return false;
                }
                if (string.equals("LEFT") && (n3 != jCCellPosition.row || jCCellPosition.column > n4)) {
                    return false;
                }
                if (string.equals("UP") && (jCCellPosition.row > n3 || n4 != jCCellPosition.column)) {
                    return false;
                }
                if (string.equals("DOWN") && (jCCellPosition.row < n3 || n4 != jCCellPosition.column)) {
                    return false;
                }
            }
            n3 = jCCellPosition.row;
            n4 = jCCellPosition.column;
            if (!this.table.editHandler.commit()) {
                return false;
            }
            if (this.table.traverseCellListeners != null) {
                JCTraverseCellEvent jCTraverseCellEvent = new JCTraverseCellEvent(this.table, table.edit_row, table.edit_column, n3, n4, string);
                this.table.fireJCTraverseCellEvent(jCTraverseCellEvent);
                n3 = jCTraverseCellEvent.next_row;
                n4 = jCTraverseCellEvent.next_column;
            }
            if ((n3 != table.edit_row || n4 != table.edit_column) && this.table.isTraverseAllowed(n3, n4)) {
                this.table.editHandler.traverse(n3, n4, false, this.initialEvent, string, true);
            }
        }
        return true;
    }

    private static boolean IS_AUTO_SCROLL_ROW(Table table) {
        int n = table.getAutoScroll();
        return n == 1 || n == 3;
    }

    private static boolean IS_AUTO_SCROLL_COLUMN(Table table) {
        int n = table.getAutoScroll();
        return n == 2 || n == 3;
    }

    private static int COLUMN(Table table, int n) {
        if (InputHandler.RESIZING_WIDTH(table)) {
            return table.resize_column;
        }
        return n;
    }

    private static int ROW(Table table, int n) {
        if (InputHandler.RESIZING_HEIGHT(table)) {
            return table.resize_row;
        }
        return n;
    }

    private static int CURRENT_WIDTH(Table table, int n) {
        if (n == -999) {
            return -999;
        }
        if (InputHandler.COLUMN(table, n) == -1) {
            return table.rowLabelWidth();
        }
        return table.columnWidth(InputHandler.COLUMN(table, n));
    }

    private static int CURRENT_HEIGHT(Table table, int n) {
        if (n == -999) {
            return -999;
        }
        if (InputHandler.ROW(table, n) == -1) {
            return table.columnLabelHeight();
        }
        return table.rowHeight(InputHandler.ROW(table, n));
    }

    private static int ROW_POS(Table table, Clip clip) {
        if (table.resize_row != -1) {
            return table.rowPosition(table.resize_row) - clip.yOffset();
        }
        return 0;
    }

    private static int COLUMN_POS(Table table, Clip clip) {
        if (table.resize_column != -1) {
            return table.columnPosition(table.resize_column) - clip.xOffset();
        }
        return 0;
    }

    private static boolean RESIZING_WIDTH(Table table) {
        return table.resize_column != -999;
    }

    private static boolean RESIZING_HEIGHT(Table table) {
        return table.resize_row != -999;
    }

    private static boolean IS_LISTMODE(Table table) {
        return table.mode == 1;
    }

    private boolean getEditable(int n, int n2) {
        if (!this.table.dataView.getEditable()) {
            return false;
        }
        return this.table.getEditable(n, n2);
    }

    private void doDrag(JCCellPosition jCCellPosition) {
        int n = this.initialCell.row;
        int n2 = this.initialCell.column;
        this.setCursor(MOVE_CURSOR);
        if (this.initialCell.row == -1) {
            n2 = jCCellPosition.column;
            if (n2 == -1) {
                return;
            }
            if (jCCellPosition.column > this.initialCell.column) {
                ++n2;
            }
        } else if (this.initialCell.column == -1) {
            n = jCCellPosition.row;
            if (n == -1) {
                return;
            }
            if (jCCellPosition.row > this.initialCell.row) {
                ++n;
            }
        }
        int n3 = 0;
        while (n3 < this.table.clip_list.length) {
            Clip clip = this.table.clip_list[n3];
            clip.beginDrag(this.initialCell.row, this.initialCell.column, n, n2);
            ++n3;
        }
    }

    private void endDrag() {
        this.dragging = false;
        int n = 0;
        while (n < this.table.clip_list.length) {
            Clip clip = this.table.clip_list[n];
            clip.endDrag();
            ++n;
        }
        this.setCursor(TRAV_CURSOR);
    }

    private void startAutoScroll() {
        if ((this.auto_scroll_vert || this.auto_scroll_horiz) && this.auto_scroll_thread == null) {
            this.auto_scroll_thread = new Thread((Runnable)this, "AUTOSCROLL");
            this.autoscrolling = true;
            this.auto_scroll_thread.start();
        }
    }

    private void stopAutoScroll(boolean bl) {
        if (bl || this.auto_scroll_horiz_direction == 0 && this.auto_scroll_vert_direction == 0) {
            if (this.auto_scroll_thread != null) {
                this.auto_scroll_thread.stop();
                this.auto_scroll_thread = null;
            }
            this.resetAutoScrolling();
        }
    }

    private void resetAutoScrolling() {
        this.autoscrolling = false;
        this.auto_scroll_horiz = false;
        this.auto_scroll_vert = false;
        this.auto_scroll_horiz_direction = 0;
        this.auto_scroll_vert_direction = 0;
    }

    public void run() {
        try {
            while (this.autoscrolling) {
                int n;
                int n2;
                int n3;
                int n4;
                JCAdjustable jCAdjustable;
                TableScrollbar tableScrollbar;
                Thread.sleep(100L);
                if (this.auto_scroll_vert) {
                    tableScrollbar = this.table.getVertSB();
                    jCAdjustable = tableScrollbar.getAdjustable();
                    n4 = jCAdjustable.getValue() + this.auto_scroll_vert_direction * 20;
                    if (n4 >= (n3 = jCAdjustable.getMaximum() - jCAdjustable.getVisibleAmount())) {
                        tableScrollbar.setValue(n3);
                        this.auto_scroll_vert_direction = 0;
                        this.stopAutoScroll(false);
                        return;
                    }
                    if (n4 < 0) {
                        tableScrollbar.setValue(0);
                        this.auto_scroll_vert_direction = 0;
                        this.stopAutoScroll(false);
                        return;
                    }
                    tableScrollbar.setValue(n4);
                    n2 = this.lastPoint.x;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (this.selecting) {
                        if (this.auto_scroll_vert_direction == 1) {
                            if (this.table.getFrozenRowPlacement() == 0) {
                                this.select(n2, this.table.cell_height + this.table.frozenRowHeight(), "EXTEND");
                            } else {
                                this.select(n2, this.table.cell_height, "EXTEND");
                            }
                        } else if (this.table.getFrozenRowPlacement() == 0) {
                            this.select(n2, this.table.getRowPixelHeight(-1) + this.table.frozenRowHeight(), "EXTEND");
                        } else {
                            this.select(n2, this.table.getRowPixelHeight(-1), "EXTEND");
                        }
                    } else if (this.dragging && this.auto_scroll_initialCell.column == -1) {
                        if (this.auto_scroll_vert_direction == 1) {
                            n = this.XYToCell((int)n2, (int)(this.table.cell_height + this.table.frozenRowHeight())).row;
                            this.doDrag(new JCCellPosition(n, this.auto_scroll_initialCell.column));
                        } else {
                            n = this.XYToCell((int)n2, (int)this.table.getRowPixelHeight((int)-1)).row;
                            this.doDrag(new JCCellPosition(n, this.auto_scroll_initialCell.column));
                        }
                    }
                }
                if (!this.auto_scroll_horiz) continue;
                tableScrollbar = this.table.getHorizSB();
                jCAdjustable = tableScrollbar.getAdjustable();
                n4 = jCAdjustable.getValue() + this.auto_scroll_horiz_direction * 20;
                if (n4 >= (n3 = jCAdjustable.getMaximum() - jCAdjustable.getVisibleAmount())) {
                    tableScrollbar.setValue(n3);
                    this.auto_scroll_horiz_direction = 0;
                    this.stopAutoScroll(false);
                    return;
                }
                if (n4 < 0) {
                    tableScrollbar.setValue(0);
                    this.auto_scroll_horiz_direction = 0;
                    this.stopAutoScroll(false);
                    return;
                }
                tableScrollbar.setValue(n4);
                n2 = this.lastPoint.y;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (this.selecting) {
                    if (this.auto_scroll_horiz_direction == 1) {
                        if (this.table.getFrozenColumnPlacement() == 0) {
                            this.select(this.table.cell_width + this.table.frozenColumnWidth(), n2, "EXTEND");
                            continue;
                        }
                        this.select(this.table.cell_width, n2, "EXTEND");
                        continue;
                    }
                    if (this.table.getFrozenColumnPlacement() == 0) {
                        this.select(this.table.getColumnPixelWidth(-1) + this.table.frozenColumnWidth(), n2, "EXTEND");
                        continue;
                    }
                    this.select(this.table.getColumnPixelWidth(-1), n2, "EXTEND");
                    continue;
                }
                if (!this.dragging || this.auto_scroll_initialCell.row != -1) continue;
                if (this.auto_scroll_horiz_direction == 1) {
                    n = this.XYToCell((int)(this.table.cell_width + this.table.frozenColumnWidth()), (int)n2).column;
                    this.doDrag(new JCCellPosition(this.auto_scroll_initialCell.row, n));
                    continue;
                }
                n = this.XYToCell((int)this.table.getColumnPixelWidth((int)-1), (int)n2).column;
                this.doDrag(new JCCellPosition(this.auto_scroll_initialCell.row, n));
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void debugMessage(int n, String string) {
        if (!this.DEBUG_MODE) {
            return;
        }
        switch (n) {
            default: 
        }
    }

    private boolean containerReserved(KeyModifier keyModifier) {
        if (keyModifier.match(27, 0)) {
            return true;
        }
        if (keyModifier.match(9, 0)) {
            return true;
        }
        return keyModifier.match(9, 1);
    }

    void dispose() {
        xyToCellPosition = null;
        this.table = null;
    }

    int getCopyPasteKey(int n, int n2) {
        int n3 = this.table.findActionKey(n, n2);
        if (n3 == 0 || n3 == 1) {
            return n3;
        }
        return -999;
    }

    void doCopyPaste(int n) {
        Transferable transferable;
        if (n == 0) {
            JCVector jCVector = (JCVector)this.table.selected_cells.clone();
            JCCellRange jCCellRange = jCVector.size() != 0 ? (JCCellRange)jCVector.elementAt(0) : new JCCellRange(this.table.edit_row, this.table.edit_column, this.table.edit_row, this.table.edit_column);
            StringCellRangeFlavor stringCellRangeFlavor = new StringCellRangeFlavor(this.table, jCCellRange);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringCellRangeFlavor, stringCellRangeFlavor);
            return;
        }
        if (n == 1 && (transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this)) != null) {
            try {
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n2 = 0;
                while (n2 < dataFlavorArray.length) {
                    if (dataFlavorArray[n2].getHumanPresentableName().equals("CellRange")) {
                        JCVector jCVector = (JCVector)transferable.getTransferData(dataFlavorArray[n2]);
                        this.loadPasteData(jCVector);
                        return;
                    }
                    if (dataFlavorArray[n2].getHumanPresentableName().equals("Unicode String")) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)transferable.getTransferData(dataFlavorArray[n2]), "\n", false);
                        JCVector jCVector = new JCVector();
                        while (stringTokenizer.hasMoreElements()) {
                            String string = (String)stringTokenizer.nextElement();
                            JCVector jCVector2 = JCUtilConverter.toVector(null, string, '\t', false);
                            if (jCVector2 == null) {
                                jCVector2 = new JCVector();
                            }
                            jCVector.addElement(jCVector2);
                        }
                        this.loadPasteData(jCVector);
                        return;
                    }
                    ++n2;
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void loadPasteData(JCVector jCVector) {
        JCCellRange jCCellRange = this.table.getSelectedCells().size() != 0 ? (JCCellRange)this.table.getSelectedCells().elementAt(0) : new JCCellRange(this.table.edit_row, this.table.edit_column, this.table.getNumRows() - 1, this.table.getNumColumns() - 1);
        if (jCCellRange.end_row == Integer.MAX_VALUE) {
            jCCellRange.start_row = -1;
            jCCellRange.end_row = this.table.getNumRows() - 1;
        }
        if (jCCellRange.end_column == Integer.MAX_VALUE) {
            jCCellRange.start_column = -1;
            jCCellRange.end_column = this.table.getNumColumns() - 1;
        }
        if (jCCellRange != null) {
            int n = jCVector.size();
            if (n == 0) {
                return;
            }
            int n2 = ((JCVector)jCVector.elementAt(0)).size();
            int n3 = jCCellRange.start_row;
            int n4 = 0;
            while (n3 <= jCCellRange.end_row && n4 < n) {
                JCVector jCVector2 = (JCVector)jCVector.elementAt(n4);
                int n5 = jCCellRange.start_column;
                int n6 = 0;
                while (n5 <= jCCellRange.end_column && n6 < n2) {
                    if (n5 == -1 || n3 == -1) {
                        if (this.table.dataView.getDataSource() instanceof VectorDataSource) {
                            if (n5 == -1) {
                                ((VectorDataSource)this.table.dataView.getDataSource()).setRowLabel(n3, jCVector2.elementAt(n6));
                            } else if (n3 == -1) {
                                ((VectorDataSource)this.table.dataView.getDataSource()).setColumnLabel(n5, jCVector2.elementAt(n6));
                            }
                        }
                    } else {
                        this.table.dataView.setCellData(jCVector2.elementAt(n6), n3, n5);
                    }
                    ++n5;
                    ++n6;
                }
                ++n3;
                ++n4;
            }
        }
    }

    static {
        TRAV_CURSOR = 2;
        NONTRAV_CURSOR = 1;
        CORNER_CURSOR = 5;
        HORIZ_CURSOR = 11;
        VERT_CURSOR = 9;
        MOVE_CURSOR = 12;
        WAIT_CURSOR = 3;
        xyToCellPosition = new JCCellPosition();
    }
}

